// SuneditorComponent.jsx
import React, { useEffect, useRef } from "react";
import SunEditor from "suneditor-react";
import "suneditor/dist/css/suneditor.min.css";

const SuneditorComponent = ({
  lang,
  name,
  value, // 🔹 controlled value
  defaultValue, // optional fallback if you ever want uncontrolled
  placeholder,
  onChange,
  options,
}) => {
  const editorRef = useRef(null);

  const handleEditorInstance = (instance) => {
    editorRef.current = instance;

    // initial sync when instance is available
    if (typeof value === "string") {
      instance.setContents(value || "");
    } else if (typeof defaultValue === "string") {
      instance.setContents(defaultValue || "");
    }
  };

  // keep editor in sync when `value` changes
  useEffect(() => {
    if (!editorRef.current) return;
    if (typeof value !== "string") return;

    // avoid infinite loops by not resetting if content already matches
    const current = editorRef.current.getContents(false);
    if (current !== value) {
      editorRef.current.setContents(value || "");
    }
  }, [value]);

  const handleChange = (content) => {
    // still let SunEditor manage typing, we just bubble up changes
    if (typeof onChange === "function") {
      onChange(content);
    }
  };

  return (
    <div className="flex flex-col-reverse w-full mb-4 pb-4 border-b">
      <SunEditor
        lang={lang}
        name={name}
        width="100%"
        height="100%"
        placeholder={placeholder}
        autoFocus={false}
        setOptions={options}
        onChange={handleChange}
        getSunEditorInstance={handleEditorInstance}
      />
    </div>
  );
};

export default SuneditorComponent;

// import React from "react";
// import SunEditor from "suneditor-react";
// import "suneditor/dist/css/suneditor.min.css";

// const SuneditorComponent = ({
//   lang,
//   name,
//   defaultValue,
//   placeholder,
//   onChange,
//   options,
// }) => {
//   return (
//     <div className="flex flex-col-reverse w-full mb-4 pb-4 border-b">
//       <SunEditor
//         lang={lang}
//         name={name}
//         defaultValue={defaultValue}
//         width="100%"
//         height="100%"
//         placeholder={placeholder}
//         autoFocus={false}
//         onChange={onChange}
//         setOptions={options}
//       />
//     </div>
//   );
// };

// export default SuneditorComponent;
