"use client";

import { useContext, useEffect, useRef } from "react";
import { SocketNotificationsContext } from "@/context/SocketProvider";
import { showTypedToast, NotificationType } from "@/lib/typedToast";

export default function SocketNotifications() {
  const notifications = useContext(SocketNotificationsContext);
  const lastId = useRef<number | null>(null);

  useEffect(() => {
    if (!notifications.length) return;

    const latest = notifications[notifications.length - 1];

    if (latest.id === lastId.current) return;
    lastId.current = latest.id;

    showTypedToast({
      type: (latest.type as NotificationType) || "info",
      message: latest.message,
    });
  }, [notifications]);

  return null;
}
