import React, { createContext, useContext, useState, useEffect } from "react";
import ApiCall from "@/api/api-calls";

const PageEditorContext = createContext();

export const PageEditorProvider = ({ children }) => {
  const [boxColumnsList, setBoxColumnsList] = useState([]);
  useEffect(() => {
    const fetchColumnsList = async () => {
      const res = await ApiCall.boxColumns.getAll();
      if (res.status === 200) {
        setBoxColumnsList(res.data);
      }
    };
    fetchColumnsList();
  }, []);
  return (
    <PageEditorContext.Provider value={{ boxColumnsList }}>
      {children}
    </PageEditorContext.Provider>
  );
};

export const usePageEditorContextManager = () => useContext(PageEditorContext);
