import { useCallback, useReducer } from "react";

const formReducer = (state, action) => {
  switch (action.type) {
    case "INPUT_CHANGE":
      // Set initial form validity
      let formIsValid = true;
      // iterate over inputs
      for (const inputId in state.inputs) {
        // if not current id
        if (!state.inputs[inputId]) {
          continue;
        }
        // if current id
        if (inputId === action.inputId) {
          // update formstate
          formIsValid = formIsValid && action.isValid;
        } else {
          // update formstate
          formIsValid = formIsValid && state.inputs[inputId].isValid;
        }
      }
      return {
        ...state,
        inputs: {
          // return all inputs state
          ...state.inputs,
          // return current input's data

          [action.inputId]: {
            value: action.value,
            isValid: action.isValid,
            isChecked: action.isChecked,
          },
        },
        // update form validity
        isValid: formIsValid,
      };
    case "SET_DATA":
      return {
        // set current inputs
        inputs: action.inputs,
        // set form validity
        isValid: action.formIsValid,
      };
    // case "CHECKBOX_CHANGE":

    default:
      return state;
  }
};

export const useForm = (initialInputs, initialFormValidity) => {
  const [formState, dispatch] = useReducer(formReducer, {
    inputs: initialInputs,
    isValid: initialFormValidity,
  });

  const handleInput = useCallback((id, value, isValid, isChecked) => {
    dispatch({
      type: "INPUT_CHANGE",
      value: value,
      inputId: id,
      isChecked: isChecked,
      isValid: isValid,
    });
  }, []);
  const handleSetInputData = useCallback((inputData, formValidity) => {
    dispatch({
      type: "SET_DATA",
      inputs: inputData,
      formIsValid: formValidity,
    });
  }, []);

  return [formState, handleInput, handleSetInputData];
};
