import { useModalManager } from "./useModalManager";
import selectableElementsData from "@/data/selectableElementsData";

const useSelectableElements = (editedContent) => {
  const { toggleModal } = useModalManager();

  // Generate elements dynamically
  return selectableElementsData(editedContent, toggleModal).map((element) => ({
    ...element,
    onClick: () => toggleModal(element.modalName), // Hook up onClick to modalName
  }));
};

export default useSelectableElements;
