import { useCallback, useState } from "react";
import { useModalManager } from "@/hooks/useModalManager";
import useDynamicManager from "@/store/managers/useDynamicManager";

import { initialData } from "@/data/data";

const useColumnActions = (parent, type, toggleModal) => {
  const {
    addColumn,
    removeColumn,
    cloneColumn,
    updateColumnOrder,
    setSelectedColumn,
    updateColumnOptions,
    changeColumnSize,
  } = useDynamicManager(type);

  const handleAddColumn = useCallback(
    (sizes) => {
      addColumn({ parentId: parent, sizes: sizes });
      toggleModal("containerModal");
    },
    [toggleModal, parent, addColumn]
  );
  const handleRemoveColumn = useCallback(
    (parent, index, size) => {
      removeColumn({
        parentId: parent,
        innerId: index,
        size: size,
      });
    },
    [removeColumn]
  );
  const handleCloneColumn = useCallback(
    (sizes, alldata, index) => {
      cloneColumn({
        parentId: parent,
        innerId: index,
        sizes: sizes,
        options:
          alldata?.[index]?.options ?? initialData.editor.column.defaults,
      });
    },
    [parent, cloneColumn]
  );
  const handleEditColumnSettings = useCallback(
    (alldata, initialData, index) => {
      setSelectedColumn({
        parentId: parent,
        innerId: index,
        options:
          alldata?.[index]?.options ?? initialData.editor.column.defaults,
      });
    },
    [setSelectedColumn, parent]
  );
  const handleUpdateColumnOptions = useCallback(
    (parent, innerid, content) => {
      updateColumnOptions({
        parentId: parent,
        innerId: innerid,
        options: content,
      });
    },
    [updateColumnOptions]
  );
  const handleChangeColumnSize = useCallback(
    (size, index, setShowColSizeList) => {
      changeColumnSize({
        parentId: parent,
        innerId: index,
        size: size,
      });

      setShowColSizeList(false);
    },
    [changeColumnSize, parent]
  );
  const handleUpdateColumnOrder = useCallback(
    (parent, index, direction) => {
      updateColumnOrder({
        parentId: parent,
        innerId: index,
        start: direction === "left" ? index - 1 : index + 1,
        end: index,
      });
    },
    [updateColumnOrder]
  );

  return {
    handleAddColumn,
    handleChangeColumnSize,
    handleRemoveColumn,
    handleCloneColumn,
    handleEditColumnSettings,
    handleUpdateColumnOptions,
    handleUpdateColumnOrder,
  };
};

export default useColumnActions;
