import { useCallback, useEffect } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";

const useContainerActions = (initialData, toggleModal, type) => {
  const {
    state,
    addContainer,
    removeContainer,
    selectedElement,
    setSelectedContainer,
    setSelectedImage,
    cleanCurrentlySelectedContent,
    cloneContainer,
    updateContainerOrder,
    resetContainerState,
    setContainerTitle,
    selectedContainerOptions,
    updateContainerContent,
    setContainerList,
  } = useDynamicManager(type);

  const handleAddContainer = useCallback(
    (data) => {
      const containerBoxes = [];
      data.columnSize.forEach((d, i) => {
        const obj = {
          parentId: state?.containerData?.length ?? 0,
          innerId: i,
          content: [],
        };
        containerBoxes.push(obj);
      });

      addContainer({
        container: {
          id: data._id,
          size: data.columnSize,
          content: containerBoxes,
          options: initialData.editor.container.defaults,
        },
      });

      toggleModal("containerModal"); // Close modal after adding container
    },
    [initialData, toggleModal, addContainer, state]
  );
  const handleRemoveContainer = useCallback(
    (e) => {
      removeContainer({
        id: e,
      });
      toggleModal("deleteContainerConsent");
    },
    [removeContainer, toggleModal]
  );
  const handleEditContainerOptions = useCallback(
    (e) => {
      toggleModal("container-options"); // Open container options modal

      setSelectedContainer({
        clickedContainer: {
          parentId: e.target.dataset.index,
          innerId: e.target.dataset.innerIndex,
          options:
            state?.containerData?.[e.target.dataset.index]?.options ?? {},
        },
      });
      setSelectedImage({
        selectedImage:
          state?.containerData?.[e.target.dataset.index]?.options
            ?.backgroundImage ?? {},
      });
    },
    [setSelectedContainer, toggleModal, state]
  );
  const editSelectedElement = useCallback(
    (e) => {
      const elementType = e.target.dataset.type;
      toggleModal(elementType); // Open the modal for the selected element type

      if (elementType === "image") {
        const img =
          state?.containerData?.[e.target.dataset.index]?.content[
            e.target.dataset.innerIndex
          ]?.content[e.target.dataset.innerElementIndex]?.content?.[0]?.image;

        if (img && Object.keys(img).length > 0) {
          setSelectedImage({
            selectedImage: img,
          });
        }
      }

      selectedElement({
        editContent: {
          parentId: e.target.dataset.index,
          innerId: e.target.dataset.innerIndex,
          innerElementIndex: e.target.dataset.innerElementIndex,
          content: [
            state?.containerData?.oxList[e.target.dataset.index]?.content[
              e.target.dataset.innerIndex
            ]?.content[e.target.dataset.innerElementIndex],
          ],
        },
      });
    },
    [state, toggleModal, selectedElement, setSelectedImage]
  );
  const cloneSelectedContainer = useCallback(
    (id) => {
      cloneContainer({
        containerIndex: id,
      });
    },
    [cloneContainer]
  );

  useEffect(() => {}, []);

  return {
    handleAddContainer,
    handleRemoveContainer,
    handleEditContainerOptions,
    editSelectedElement,
    cloneSelectedContainer,
  };
};

export default useContainerActions;
