import { useEffect, useState } from "react";

/**
 * Returns a debounced version of the input value.
 * @param {any} value - The value to debounce
 * @param {number} delay - Delay in ms
 * @returns {any} Debounced value
 */
export default function useDebounce(value, delay = 300) {
  const [debounced, setDebounced] = useState(value);

  useEffect(() => {
    const timer = setTimeout(() => {
      setDebounced(value);
    }, delay);

    return () => clearTimeout(timer);
  }, [value, delay]);

  return debounced;
}
