import { useCallback } from "react";
import { useDispatch, useSelector } from "react-redux";
import {
  selectedElement,
  updateContainerContent,
} from "@/store/slices/pageEditorSlice";

export const useEditorBlog = ({ toggleModal, modalName }) => {
  const dispatch = useDispatch();
  const editableContent = useSelector(
    (state) => state.pageEditor.current.content
  );
  const handleUpdateContainerContent = useCallback(() => {
    dispatch(updateContainerContent());
  }, []);
  const handleSubmitBlogData = useCallback((contentData, inputRefs) => {
    const content = contentData;
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      if (ref) {
        if (ref.props) {
          // Handle cases where props contain value data
          if (Array.isArray(ref.props.value)) {
            // Handle arrays of values
            content[key] = ref.props.value.map((item) => item.value);
          } else {
            // Handle single values
            content[key] = ref.props.value?.value ?? "";
          }
        } else {
          // Handle cases where ref itself holds value data
          content[key] = ref?.value ?? "";
        }
      }
    });
    dispatch(
      selectedElement({
        content: content,
      })
    );
    dispatch(updateContainerContent());
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
  }, []);
  return {
    //state
    editableContent,
    //helpers
    handleSubmitBlogData,
    handleUpdateContainerContent,
  };
};
