import { useCallback, useEffect, useState } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";

export const useEditorButton = ({ toggleModal, modalName, type }) => {
  const [editableContent, setEditableContent] = useState(null);

  const { state, selectedElement, addcurrentElementToColumn } =
    useDynamicManager(type);

  useEffect(() => {
    setEditableContent(state.current.content);
  }, [state]);

  const handleSelectedElement = useCallback((content) => {
    selectedElement({
      content: content,
    });
  }, []);

  const handleUpdateContainerContent = useCallback(() => {
    addcurrentElementToColumn();
  }, []);

  const handleSubmitEditorButton = useCallback(
    (contendData, inputRefs) => {
      const content = contendData;
      Object.entries(inputRefs.current).forEach(([key, ref]) => {
        if (ref) {
          if (ref.props) {
            // Handle cases where props contain value data
            if (Array.isArray(ref.props.value)) {
              // Handle arrays of values
              content[key] = ref.props.value.map((item) => item.value);
            } else {
              // Handle single values
              content[key] = ref.props.value?.value ?? "";
            }
          } else {
            // Handle cases where ref itself holds value data
            content[key] = ref?.value ?? "";
          }
        }
      });
      handleSelectedElement(content);
      handleUpdateContainerContent();
      toggleModal(modalName);
      toggleModal("showSelectElementModal");
    },
    [
      handleSelectedElement,
      handleUpdateContainerContent,
      toggleModal,
      modalName,
    ]
  );

  return {
    //state
    editableContent,
    //helpers
    handleSubmitEditorButton,
  };
};
