import { useCallback, useEffect, useRef, useState } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";

export const useEditorImage = ({ toggleModal, modalName, type }) => {
  const {
    state,
    resetImageState,
    addcurrentElementToColumn,
    setSelectedImage,
  } = useDynamicManager(type);
  const [editableContent, setEditableContent] = useState([]);

  useEffect(() => {
    if (state) {
      setEditableContent(state?.current?.content);
    }
  }, [state]);

  useEffect(() => {
    resetImageState();

    if (state.current.content?.length > 0) {
      setSelectedImage({
        selectedImage: state.current.content?.[0]?.content?.[0]?.image,
      });
    }
  }, []);

  const inputRefs = useRef([]);

  const handleImageRemove = useCallback(() => {
    resetImageState();
  }, []);

  const handleUpdateContainerContent = useCallback(() => {
    addcurrentElementToColumn();
  }, []);

  return {
    //state
    editableContent,
    //refs
    inputRefs,
    //helpers
    handleImageRemove,
    handleUpdateContainerContent,
  };
};
