import { useCallback, useEffect, useRef, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import ApiCall from "@/api/api-calls";
import {
  clearSelectedImage,
  selectedElement,
  updateContainerContent,
  selectSingleArticle,
} from "@/store/slices/pageEditorSlice";
import { findLastIndexOfChar } from "@/utils/findLastIndexOfChar";

export const useEditorSingleArticle = ({ toggleModal, modalName }) => {
  const dispatch = useDispatch();
  const editableContent = useSelector(
    (state) => state.pageEditor.current.content
  );
  const selectedArticle = useSelector(
    (state) => state.pageEditor.selectedArticle
  );
  const handleSelectedElement = useCallback(
    (content) => {
      dispatch(
        selectedElement({
          content: content,
        })
      );
    },
    [dispatch]
  );

  const handleUpdateContainerContent = useCallback(() => {
    dispatch(updateContainerContent());
  }, [dispatch]);

  const handleSelectSingleArticle = useCallback(() => {
    dispatch(
      selectSingleArticle({
        article: editableContent?.[0]?.content?.[0]?.selectedArticle ?? {},
      })
    );
  }, [dispatch, editableContent]);

  const handleSubmitSingleArticle = useCallback(
    (contendData, inputRefs) => {
      const content = contendData;
      Object.entries(inputRefs.current).forEach(([key, ref]) => {
        if (ref) {
          if (ref.props) {
            // Handle cases where props contain value data
            if (Array.isArray(ref.props.value)) {
              // Handle arrays of values
              content[key] = ref.props.value.map((item) => item.value);
            } else {
              // Handle single values
              content[key] = ref.props.value?.value ?? "";
            }
          } else {
            // Handle cases where ref itself holds value data
            content[key] = ref?.value ?? "";
          }
        }
      });
      handleSelectedElement(content);
      handleUpdateContainerContent();
      toggleModal(modalName);
      toggleModal("showSelectElementModal");
    },
    [
      handleSelectedElement,
      handleUpdateContainerContent,
      toggleModal,
      modalName,
    ]
  );

  return {
    //state
    editableContent,
    selectedArticle,
    //helpers
    handleSelectSingleArticle,
    handleSubmitSingleArticle,
  };
};
