import { useCallback, useEffect } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";

export const useEditorSingleProduct = ({ toggleModal, modalName, type }) => {
  const {
    state,
    selectedElement,
    selectSingleProduct,
    updateContainerContent,
    addcurrentElementToColumn,
    clearSelectSingleProduct,
    resetElementState,
  } = useDynamicManager(type);

  const handleSelectedElement = useCallback((content) => {
    selectedElement({
      content: content,
    });
  }, []);

  const handleUpdateContainerContent = useCallback(() => {
    updateContainerContent();
  }, []);

  const handleSelectSingleProduct = useCallback(() => {
    selectSingleProduct({
      product: state?.selectedProduct ?? {},
    });
  }, []);

  useEffect(() => {
    // resetSliderState();
    if (state.current.content?.length > 0) {
      selectSingleProduct({
        product: state.current.content?.[0]?.content?.[0]?.selectedProduct,
      });
    }
  }, []);

  const handleSubmitSingleProduct = useCallback(
    (contendData, inputRefs) => {
      const content = contendData;
      Object.entries(inputRefs.current).forEach(([key, ref]) => {
        if (ref) {
          if (ref.props) {
            // Handle cases where props contain value data
            if (Array.isArray(ref.props.value)) {
              // Handle arrays of values
              content[key] = ref.props.value.map((item) => item.value);
            } else {
              // Handle single values
              content[key] = ref.props.value?.value ?? "";
            }
          } else {
            // Handle cases where ref itself holds value data
            content[key] = ref?.value ?? "";
          }
        }
      });
      selectedElement({
        content: content,
      });
      addcurrentElementToColumn();
      resetElementState();
      clearSelectSingleProduct();
      toggleModal(modalName);
      toggleModal("showSelectElementModal");
    },
    [toggleModal, modalName]
  );

  return {
    //helpers
    handleSelectSingleProduct,
    handleSubmitSingleProduct,
  };
};
