import { useCallback } from "react";
import { useDispatch } from "react-redux";
import {
  removeElement,
  updateColumnElementOrder,
  moveColumnElement,
  cloneElement,
} from "@/store/slices/pageEditorSlice";

const useElementActions = (toggleModal) => {
  const dispatch = useDispatch();

  const handleRemoveElement = useCallback(
    (parentId, innerId, innerElementIndex) => {
      dispatch(
        removeElement({
          parentId: parentId,
          innerId: innerId,
          innerElementIndex: innerElementIndex,
        })
      );
    },
    [dispatch, toggleModal, parent]
  );
  const handleUpdateColumnElementOrder = useCallback(
    (parentId, innerId, innerElementIndex, direction) => {
      dispatch(
        updateColumnElementOrder({
          parentId: parentId,
          innerId: innerId,
          innerElementIndex: innerElementIndex,
          start:
            direction === "up" ? innerElementIndex + 1 : innerElementIndex - 1,
          end: innerElementIndex,
        })
      );
    },
    []
  );
  const handleMoveColumnElement = useCallback(
    (parentId, innerId, index, direction) => {
      dispatch(
        moveColumnElement({
          parentId: parentId,
          innerId: innerId,
          innerElementIndex: index,
          newColumnIndex: direction === "left" ? innerId - 1 : innerId + 1,
        })
      );
    },
    []
  );
  const handleCloneElement = useCallback(
    (parentId, innerId, innerElementIndex) => {
      dispatch(
        cloneElement({
          parentId: parentId,
          innerId: innerId,
          innerElementIndex: innerElementIndex,
        })
      );
    },
    []
  );

  return {
    handleRemoveElement,
    handleUpdateColumnElementOrder,
    handleMoveColumnElement,
    handleCloneElement,
  };
};

export default useElementActions;
