import { useEffect, useState } from "react";

const useInfiniteScroll = (totalRecords, pageSize, page, setPage) => {
  const [noMoreData, setNoMoreData] = useState(false);

  useEffect(() => {
    const totalPages = Math.ceil(totalRecords / pageSize);
    if (page >= totalPages) {
      setNoMoreData(true);
    }
  }, [page, totalRecords, pageSize]);

  const loadMore = () => {
    setPage((prevPage) => prevPage + 1);
  };

  return { loadMore, noMoreData };
};

export default useInfiniteScroll;
