import { useCallback, useEffect, useRef, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import ApiCall from "@/api/api-calls";

import {
  selectedSliderImages,
  cleanupGalleryImages,
  selectedGalleryImages,
  removeSingleGalleryImage,
  cloneGalleryImage,
  updateGalleryImageOrder,
  selectedElement,
  updateContainerContent,
  selectedImage,
} from "@/store/slices/pageEditorSlice";
import { findLastIndexOfChar } from "@/utils/findLastIndexOfChar";
import { addGalleryImages } from "@/store/articleBoxSlice";

export const useMediaStore = () => {
  const dispatch = useDispatch();
  const handleAddGalleryImages = useCallback((type, id, images) => {
    switch (type) {
      case "article-gallery":
        dispatch(
          addGalleryImages({
            type: type,
            id: id,
            images: images,
          })
        );
      case "editor-gallery":
        dispatch(selectedGalleryImages({ selectedImages: images }));
      case "editor-slider":
        dispatch(selectedSliderImages({ selectedImages: images }));
    }
  }, []);
  const handleSelectEditorImage = useCallback((image) => {
    dispatch(
      selectedImage({
        selectedImage: image,
      })
    );
  }, []);
  // const handleAddGalleryImages = useCallback(() => {}, []);
  // const handleAddGalleryImages = useCallback(() => {}, []);
  // const handleAddGalleryImages = useCallback(() => {}, []);
  // const handleAddGalleryImages = useCallback(() => {}, []);
  return { handleSelectEditorImage, handleAddGalleryImages };
};
