"use client";
import { useCallback, useState } from "react";

export default function useModalMap() {
  const [open, setOpen] = useState<Record<string, boolean>>({});

  const isModalOpen = useCallback((key: string) => !!open[key], [open]);
  const toggleModal = useCallback((key: string, value?: boolean) => {
    setOpen((s) => ({ ...s, [key]: value ?? !s[key] }));
  }, []);

  return { isModalOpen, toggleModal };
}
