"use server";

import { cookies } from "next/headers";
import { fetchWithAuth } from "./fetchUtils";

const AUTH_COOKIE_NAME = "edSId"; // <- your cookie name

export async function fetchWithAuthFromCookies(
  path: string,
  options: RequestInit & {
    responseType?: "json" | "text" | "blob" | "arrayBuffer" | "raw";
  } = {}
) {
  // ⬇️ FIX: await cookies(), THEN call .get
  const cookieStore = await cookies();
  const token = cookieStore.get(AUTH_COOKIE_NAME)?.value;

  if (!token) {
    throw new Error("❌ No auth token found in cookies");
  }

  return fetchWithAuth(path, token, options);
}
