// src/lib/swal.ts
import Swal from "sweetalert2";
import withReactContent from "sweetalert2-react-content";
import type { SweetAlertIcon, SweetAlertOptions } from "sweetalert2";

const MySwal = withReactContent(Swal);

type ToastArgs = {
  title: string;
  text?: string;
  icon?: SweetAlertIcon;
} & Partial<SweetAlertOptions>;

export const showToast = ({ title, text, icon = "info", ...rest }: ToastArgs) =>
  MySwal.fire({
    title,
    text,
    icon,
    toast: true,
    position: "bottom-end",
    showConfirmButton: false,
    timer: 10000,
    showCloseButton: true,
    ...rest,
  });
