// src/lib/typedToast.ts
import Swal, { SweetAlertIcon } from "sweetalert2";
import withReactContent from "sweetalert2-react-content";

const MySwal = withReactContent(Swal);

export type NotificationType =
  | "info"
  | "success"
  | "warning"
  | "error"
  | "chat";

const typeMap: Record<
  NotificationType,
  { icon: SweetAlertIcon; background: string }
> = {
  info: { icon: "info", background: "#e0f2fe" }, // blue-100
  success: { icon: "success", background: "#dcfce7" }, // green-100
  warning: { icon: "warning", background: "#fef9c3" }, // yellow-100
  error: { icon: "error", background: "#fee2e2" }, // red-100
  chat: { icon: "info", background: "#f3e8ff" }, // purple-100
};

type ShowTypedToastArgs = {
  type?: NotificationType;
  message: string;
};

export function showTypedToast({ type = "info", message }: ShowTypedToastArgs) {
  const style = typeMap[type];

  return MySwal.fire({
    title: message,
    toast: true,
    position: "bottom-end",
    showConfirmButton: false,
    timer: 6000,
    timerProgressBar: true,
    icon: style.icon,
    background: style.background,
    showCloseButton: true,
    customClass: {
      popup: "border border-black/10 shadow-md rounded-lg text-sm px-2",
    },
  });
}
