// store/factory/containerSliceFactory.js
import { createSlice } from "@reduxjs/toolkit";
import { reorder } from "../../utils/reorder";

// export const containerInitialState = {
//   containerData: [],
//   selectedContainer: null,
// };
export const containerInitialState = (stateKey = "containerData") => ({
  [stateKey]: [],
  containerData: [],
  selectedContainer: null,
});

export const getContainerReducers = ({ stateKey = "containerData" } = {}) => ({
  addContainer: (state, action) => {
    console.log("state", state, "action", action, "stateKey", stateKey);
    if (!state[stateKey]) state[stateKey] = [];
    state[stateKey].push(action.payload.container);
  },
  setSelectedContainer: (state, action) => {
    const container = state[stateKey][action.payload.clickedContainer.parentId];
    state.selectedContainer = action.payload.clickedContainer;
    if (container) {
      state.selectedContainer.options = container.options || {};
    }
  },
  updateContainerOptions: (state, action) => {
    const box = state[stateKey][state.selectedContainer.parentId];

    state.selectedContainer.options = action.payload.options;
    if (box) box.options = action.payload.options;
  },
  removeContainer: (state, action) => {
    const index = action.payload.id;
    if (
      typeof index === "number" &&
      index >= 0 &&
      index < state[stateKey].length
    ) {
      state[stateKey].splice(index, 1);
    }
  },
  cleanCurrentlySelectedContent: (state) => {
    state.selectedContainer = null;
  },
  setContainerList: (state, action) => {
    state[stateKey] = action.payload.data;
  },
  updateContainerContent: (state, action) => {
    const container = state[stateKey][state.selectedContainer.parentId];
    if (container) {
      const column = container.content?.[state.selectedContainer.innerId];
      if (column) {
        const element =
          column.content?.[state.selectedContainer.innerElementIndex];
        if (element) {
          column.content[state.selectedContainer.innerElementIndex] =
            state.selectedContainer;
        } else {
          column.content.push(state.selectedContainer);
        }
      }
    }
  },
  selectedContainerOptions: (state) => {
    state.selectedContainer.options =
      state[stateKey][state.selectedContainer?.parentId]?.options;
  },
  setContainerTitle: (state, action) => {
    const { parentId, title } = action.payload;

    state[stateKey][parentId].title = title;
  },
  cloneContainer: (state, action) => {
    const { containerIndex } = action.payload;
    const container = state[stateKey][containerIndex];

    if (container) {
      const clonedContainer = {
        ...container,
        // Deep clone nested arrays like content and size
        content: container.content.map((column, idx) => ({
          ...column,
          content: [...column.content], // clone inner content
          innerId: idx,
        })),
        size: [...container.size],
        // 🟢 Add a default title if missing
      };

      state[stateKey].push(clonedContainer);
    }
  },

  resetContainerState: (state) => {
    state[stateKey] = [];
    state.selectedContainer = null;
  },
  updateContainerOrder: (state, action) => {
    const { parentId, start, end } = action.payload;
    state[stateKey] = reorder(state[stateKey], start, end);
    state[stateKey].map((d, i) => {
      d?.content?.length > 0 &&
        d?.content.map((c) => {
          c.parentId = i;
        });
    });
  },
});
