// store/managers/usePageEditorManager.js
"use client";

import useGenericManager from "./useGenericManager";
import { articleEditorActions } from "@/store/actions/articleEditorActions";

const useArticleEditorManager = () =>
  useGenericManager({
    actions: {
      // ✅ Container actions
      addContainer: articleEditorActions.addContainer,
      removeContainer: articleEditorActions.removeContainer,
      setSelectedContainer: articleEditorActions.setSelectedContainer,
      setContainerList: articleEditorActions.setContainerList,
      updateContainerContent: articleEditorActions.updateContainerContent,
      selectedContainerOptions: articleEditorActions.selectedContainerOptions,
      setContainerTitle: articleEditorActions.setContainerTitle,
      resetContainerState: articleEditorActions.resetContainerState,
      cleanCurrentlySelectedContent:
        articleEditorActions.cleanCurrentlySelectedContent,
      cloneContainer: articleEditorActions.cloneContainer,
      updateContainerOrder: articleEditorActions.updateContainerOrder,
      updateContainerOptions: articleEditorActions.updateContainerOptions,
      reorderContainersByPosition:
        articleEditorActions.reorderContainersByPosition,
      // ✅ Column actions
      addColumn: articleEditorActions.addColumn,
      setSelectedColumn: articleEditorActions.setSelectedColumn,
      updateColumnOrder: articleEditorActions.updateColumnOrder,
      updateColumnOptions: articleEditorActions.updateColumnOptions,
      changeColumnSize: articleEditorActions.changeColumnSize,
      cloneColumn: articleEditorActions.cloneColumn,
      removeColumn: articleEditorActions.removeColumn,
      moveColumnAcrossContainers:
        articleEditorActions.moveColumnAcrossContainers,
      reorderColumnsByPosition: articleEditorActions.reorderColumnsByPosition,

      // ✅ Element actions
      addElement: articleEditorActions.addElement,
      removeElement: articleEditorActions.removeElement,
      selectedElement: articleEditorActions.selectedElement,
      setSelectCurrentElement: articleEditorActions.setSelectCurrentElement,
      setEditedElement: articleEditorActions.setEditedElement,
      addcurrentElementToColumn: articleEditorActions.addcurrentElementToColumn,
      setElementList: articleEditorActions.setElementList,
      updateElementContent: articleEditorActions.updateElementContent,
      resetElementState: articleEditorActions.resetElementState,
      editElement: articleEditorActions.editElement,
      moveElementAcrossContainers:
        articleEditorActions.moveElementAcrossContainers,
      moveElementByPosition: articleEditorActions.moveElementByPosition,

      // ✅ Gallery actions
      setFeaturedImage: articleEditorActions.setFeaturedImage,
      resetImageState: articleEditorActions.resetImageState,
      resetFeaturedImageState: articleEditorActions.resetFeaturedImageState,
      setGalleryImages: articleEditorActions.setGalleryImages,
      setTags: articleEditorActions.setTags,
      resetGalleryState: articleEditorActions.resetGalleryState,
      resetSliderState: articleEditorActions.resetSliderState,
      setSelectedSliderImages: articleEditorActions.setSelectedSliderImages,
      updateSliderImageOrder: articleEditorActions.updateSliderImageOrder,
      removeSingleSliderImage: articleEditorActions.removeSingleSliderImage,
      setSelectedImage: articleEditorActions.setSelectedImage,
      setSelectedGalleryImages: articleEditorActions.setSelectedGalleryImages,
      updateGalleryImageOrder: articleEditorActions.updateGalleryImageOrder,
      removeImageFromGallery: articleEditorActions.removeImageFromGallery,
      cloneGalleryImage: articleEditorActions.cloneGalleryImage,
      removeSingleGalleryImage: articleEditorActions.removeSingleGalleryImage,
      selectedImage: articleEditorActions.selectedImage,
      // ✅ Common props actions
      setProps: articleEditorActions.setProps,
      resetPropsState: articleEditorActions.resetPropsState,

      // ✅ Slice-specific actions
      setPublishedArticle: articleEditorActions.setPublishedArticle,
      loadArticleEditorInitialData:
        articleEditorActions.loadArticleEditorInitialData,
      resetCurrent: articleEditorActions.resetCurrent,
      selectSingleProduct: articleEditorActions.selectSingleProduct,
      clearSelectSingleProduct: articleEditorActions.clearSelectSingleProduct,
      selectSingleArticle: articleEditorActions.selectSingleArticle,
      clearSelectSingleArticle: articleEditorActions.clearSelectSingleArticle,
      displayedBlogs: articleEditorActions.displayedBlogs,
      clearDisplayedBlogs: articleEditorActions.clearDisplayedBlogs,
      displayedCategories: articleEditorActions.displayedCategories,
      clearDisplayedCategories: articleEditorActions.clearDisplayedCategories,
    },
    stateKey: "articleEditor",
  });

export default useArticleEditorManager;
