// store/managers/useGenericManager.js
"use client";

import { useDispatch, useSelector } from "react-redux";

const useGenericManager = ({ actions, stateKey }) => {
  const dispatch = useDispatch();
  const slice = useSelector((state) => state[stateKey]);

  const containerData = slice?.containerData;

  const wrappedActions = {};
  for (const [key, actionCreator] of Object.entries(actions)) {
    wrappedActions[key] = (payload) => dispatch(actionCreator(payload));
  }

  return {
    ...wrappedActions,
    state: {
      ...slice,
      containerData,
    },
  };
};

export default useGenericManager;
