// store/managers/usePageEditorManager.js
"use client";

import useGenericManager from "./useGenericManager";
import { pageEditorActions } from "@/store/actions/pageEditorActions";

const usePageEditorManager = () =>
  useGenericManager({
    actions: {
      // ✅ Container actions
      addContainer: pageEditorActions.addContainer,
      removeContainer: pageEditorActions.removeContainer,
      setSelectedContainer: pageEditorActions.setSelectedContainer,
      setContainerList: pageEditorActions.setContainerList,
      updateContainerContent: pageEditorActions.updateContainerContent,
      selectedContainerOptions: pageEditorActions.selectedContainerOptions,
      setContainerTitle: pageEditorActions.setContainerTitle,
      resetContainerState: pageEditorActions.resetContainerState,
      cleanCurrentlySelectedContent:
        pageEditorActions.cleanCurrentlySelectedContent,
      cloneContainer: pageEditorActions.cloneContainer,
      updateContainerOrder: pageEditorActions.updateContainerOrder,
      updateContainerOptions: pageEditorActions.updateContainerOptions,
      reorderContainersByPosition:
        pageEditorActions.reorderContainersByPosition,

      // ✅ Column actions
      addColumn: pageEditorActions.addColumn,
      setSelectedColumn: pageEditorActions.setSelectedColumn,
      updateColumnOrder: pageEditorActions.updateColumnOrder,
      updateColumnOptions: pageEditorActions.updateColumnOptions,
      changeColumnSize: pageEditorActions.changeColumnSize,
      cloneColumn: pageEditorActions.cloneColumn,
      removeColumn: pageEditorActions.removeColumn,
      reorderColumnsByPosition: pageEditorActions.reorderColumnsByPosition,

      // ✅ Element actions
      addElement: pageEditorActions.addElement,
      removeElement: pageEditorActions.removeElement,
      selectedElement: pageEditorActions.selectedElement,
      setSelectCurrentElement: pageEditorActions.setSelectCurrentElement,
      setEditedElement: pageEditorActions.setEditedElement,
      addcurrentElementToColumn: pageEditorActions.addcurrentElementToColumn,
      setElementList: pageEditorActions.setElementList,
      updateElementContent: pageEditorActions.updateElementContent,
      resetElementState: pageEditorActions.resetElementState,
      editElement: pageEditorActions.editElement,
      moveElementByPosition: pageEditorActions.moveElementByPosition,
      cloneElement: pageEditorActions.cloneElement,
      // ✅ Gallery actions
      setFeaturedImage: pageEditorActions.setFeaturedImage,
      resetImageState: pageEditorActions.resetImageState,
      removeFeaturedImage: pageEditorActions.resetFeaturedImageState,
      setGalleryImages: pageEditorActions.setGalleryImages,
      setTags: pageEditorActions.setTags,
      resetGalleryState: pageEditorActions.resetGalleryState,
      resetSliderState: pageEditorActions.resetSliderState,
      setSelectedSliderImages: pageEditorActions.setSelectedSliderImages,
      updateSliderImageOrder: pageEditorActions.updateSliderImageOrder,
      removeSingleSliderImage: pageEditorActions.removeSingleSliderImage,
      setSelectedImage: pageEditorActions.setSelectedImage,
      setSelectedGalleryImages: pageEditorActions.setSelectedGalleryImages,
      updateGalleryImageOrder: pageEditorActions.updateGalleryImageOrder,
      removeImageFromGallery: pageEditorActions.removeImageFromGallery,
      cloneGalleryImage: pageEditorActions.cloneGalleryImage,
      removeSingleGalleryImage: pageEditorActions.removeSingleGalleryImage,
      selectedImage: pageEditorActions.selectedImage,
      // ✅ Common props actions
      setProps: pageEditorActions.setProps,
      resetPropsState: pageEditorActions.resetPropsState,

      // ✅ Slice-specific actions
      setPublishedPage: pageEditorActions.setPublishedPage,
      setHasParentPage: pageEditorActions.setHasParentPage,
      setShowPageInMenu: pageEditorActions.setShowPageInMenu,
      setSelectedParentPage: pageEditorActions.setSelectedParentPage,
      setCurrentChildPages: pageEditorActions.setCurrentChildPages,
      resetPageEditorState: pageEditorActions.resetPageEditorState,
      selectSingleProduct: pageEditorActions.selectSingleProduct,
      clearSelectSingleProduct: pageEditorActions.clearSelectSingleProduct,
      selectSingleForm: pageEditorActions.selectSingleForm,
      clearSelectSingleForm: pageEditorActions.clearSelectSingleForm,
      selectSingleArticle: pageEditorActions.selectSingleArticle,
      clearSelectSingleArticle: pageEditorActions.clearSelectSingleArticle,
      displayedBlogs: pageEditorActions.displayedBlogs,
      clearDisplayedBlogs: pageEditorActions.clearDisplayedBlogs,
      displayedCategories: pageEditorActions.displayedCategories,
      clearDisplayedCategories: pageEditorActions.clearDisplayedCategories,
      loadPageEditorInitialData: pageEditorActions.loadPageEditorInitialData,
      resetCurrent: pageEditorActions.resetCurrent,
    },
    stateKey: "pageEditor",
  });

export default usePageEditorManager;
