import useGenericManager from "./useGenericManager";
import { peopleActions } from "@/store/actions/peopleActions";

const usePeopleManager = () =>
  useGenericManager({
    actions: {
      // Gallery actions
      setFeaturedImage: peopleActions.setFeaturedImage,
      removeFeaturedImage: peopleActions.removeFeaturedImage,
      setGalleryImages: peopleActions.setGalleryImages,
      setTags: peopleActions.setTags,
      resetGalleryState: peopleActions.resetGalleryState,

      // Custom people actions
      selectDepartmentFeaturedDocument:
        peopleActions.selectDepartmentFeaturedDocument,
      removeDepartmentFeaturedDocument:
        peopleActions.removeDepartmentFeaturedDocument,
      setLocations: peopleActions.setLocations,
      setSpecializations: peopleActions.setSpecializations,
      setPeoples: peopleActions.setPeoples,
      setDepartments: peopleActions.setDepartments,
      setDepartmentTypes: peopleActions.setDepartmentTypes,
      setArtforms: peopleActions.setArtforms,
    },
    stateKey: "peopleData",
  });

export default usePeopleManager;
