import useGenericManager from "./useGenericManager";
import { productItemActions } from "@/store/actions/productItemActions";

const useProductItemManager = () =>
  useGenericManager({
    actions: {
      // Common actions
      productStockValue: productItemActions.productStockValue,
      productInStock: productItemActions.productInStock,
      productIsNew: productItemActions.productIsNew,
      productIsFeatured: productItemActions.productIsFeatured,
      setParentProduct: productItemActions.setParentProduct,
      setProductItemData: productItemActions.setProductItemData,
      resetItemState: productItemActions.resetItemState,
      // Gallery actions
      setFeaturedImage: productItemActions.setFeaturedImage,
      resetFeaturedImageState: productItemActions.resetFeaturedImageState,
      setSelectedGalleryImages: productItemActions.setSelectedGalleryImages,
      removeImageFromGallery: productItemActions.removeImageFromGallery,
      resetGalleryState: productItemActions.resetGalleryState,
      updateGalleryImageOrder: productItemActions.updateGalleryImageOrder,
      cloneGalleryImage: productItemActions.cloneGalleryImage,
      resetImageState: productItemActions.resetImageState,
      selectedGalleryImages: productItemActions.selectedGalleryImages,
      setSelectedImage: productItemActions.setSelectedImage,
      // Custom product item actions
      setSize: productItemActions.setSize,
      setColor: productItemActions.setColor,
      setTag: productItemActions.setTag,
      productWeight: productItemActions.productWeight,
      productDiscount: productItemActions.productDiscount,
      loadProductInitialData: productItemActions.loadProductInitialData,
      setProductContainerList: productItemActions.setProductContainerList,
      setProductParentGroup: productItemActions.setProductParentGroup,
      // Container actions
      addContainer: productItemActions.addContainer,
      setSelectedContainer: productItemActions.setSelectedContainer,
      removeContainer: productItemActions.removeContainer,
      cleanCurrentlySelectedContent:
        productItemActions.cleanCurrentlySelectedContent,
      setContainerList: productItemActions.setContainerList,
      updateContainerContent: productItemActions.updateContainerContent,
      selectedContainerOptions: productItemActions.selectedContainerOptions,
      setContainerTitle: productItemActions.setContainerTitle,
      resetContainerState: productItemActions.resetContainerState,
      cloneContainer: productItemActions.cloneContainer,
      updateContainerOrder: productItemActions.updateContainerOrder,
      // Column actions
      addColumn: productItemActions.addColumn,
      setSelectedColumn: productItemActions.setSelectedColumn,
      updateColumnOrder: productItemActions.updateColumnOrder,
      updateColumnOptions: productItemActions.updateColumnOptions,
      changeColumnSize: productItemActions.changeColumnSize,
      cloneColumn: productItemActions.cloneColumn,
      removeColumn: productItemActions.removeColumn,
      moveColumnAcrossContainers: productItemActions.moveColumnAcrossContainers,

      // Element actions
      addElement: productItemActions.addElement,
      selectedElement: productItemActions.selectedElement,
      updateColumnElementOrder: productItemActions.updateColumnElementOrder,
      moveColumnElement: productItemActions.moveColumnElement,
      removeElement: productItemActions.removeElement,
      cloneElement: productItemActions.cloneElement,
      setEditedElement: productItemActions.setEditedElement,
      setSelectCurrentElement: productItemActions.setSelectCurrentElement,
      addcurrentElementToColumn: productItemActions.addcurrentElementToColumn,
      resetElementState: productItemActions.resetElementState,
      moveElementAcrossContainers:
        productItemActions.moveElementAcrossContainers,
    },
    stateKey: "productItem",
  });

export default useProductItemManager;
