// store/managers/usePageEditorManager.js
"use client";

import useGenericManager from "./useGenericManager";
import { staticPageEditorActions } from "@/store/actions/staticPageEditorActions";

const useStaticPageEditorManager = () =>
  useGenericManager({
    actions: {
      // ✅ Container actions
      addContainer: staticPageEditorActions.addContainer,
      removeContainer: staticPageEditorActions.removeContainer,
      setSelectedContainer: staticPageEditorActions.setSelectedContainer,
      setContainerList: staticPageEditorActions.setContainerList,
      updateContainerContent: staticPageEditorActions.updateContainerContent,
      selectedContainerOptions:
        staticPageEditorActions.selectedContainerOptions,
      setContainerTitle: staticPageEditorActions.setContainerTitle,
      resetContainerState: staticPageEditorActions.resetContainerState,
      cleanCurrentlySelectedContent:
        staticPageEditorActions.cleanCurrentlySelectedContent,
      cloneContainer: staticPageEditorActions.cloneContainer,
      updateContainerOrder: staticPageEditorActions.updateContainerOrder,
      updateContainerOptions: staticPageEditorActions.updateContainerOptions,
      reorderContainersByPosition:
        staticPageEditorActions.reorderContainersByPosition,
      // ✅ Column actions
      addColumn: staticPageEditorActions.addColumn,
      setSelectedColumn: staticPageEditorActions.setSelectedColumn,
      updateColumnOrder: staticPageEditorActions.updateColumnOrder,
      updateColumnOptions: staticPageEditorActions.updateColumnOptions,
      changeColumnSize: staticPageEditorActions.changeColumnSize,
      cloneColumn: staticPageEditorActions.cloneColumn,
      removeColumn: staticPageEditorActions.removeColumn,
      moveColumnAcrossContainers:
        staticPageEditorActions.moveColumnAcrossContainers,
      reorderColumnsByPosition:
        staticPageEditorActions.reorderColumnsByPosition,

      // ✅ Element actions
      addElement: staticPageEditorActions.addElement,
      removeElement: staticPageEditorActions.removeElement,
      selectedElement: staticPageEditorActions.selectedElement,
      setSelectCurrentElement: staticPageEditorActions.setSelectCurrentElement,
      setEditedElement: staticPageEditorActions.setEditedElement,
      addcurrentElementToColumn:
        staticPageEditorActions.addcurrentElementToColumn,
      setElementList: staticPageEditorActions.setElementList,
      updateElementContent: staticPageEditorActions.updateElementContent,
      resetElementState: staticPageEditorActions.resetElementState,
      editElement: staticPageEditorActions.editElement,
      moveElementAcrossContainers:
        staticPageEditorActions.moveElementAcrossContainers,
      moveElementByPosition: staticPageEditorActions.moveElementByPosition,
      cloneElement: staticPageEditorActions.cloneElement,

      // ✅ Gallery actions
      setFeaturedImage: staticPageEditorActions.setFeaturedImage,
      resetImageState: staticPageEditorActions.resetImageState,
      removeFeaturedImage: staticPageEditorActions.resetFeaturedImageState,
      setGalleryImages: staticPageEditorActions.setGalleryImages,
      setTags: staticPageEditorActions.setTags,
      resetGalleryState: staticPageEditorActions.resetGalleryState,
      resetSliderState: staticPageEditorActions.resetSliderState,
      setSelectedSliderImages: staticPageEditorActions.setSelectedSliderImages,
      updateSliderImageOrder: staticPageEditorActions.updateSliderImageOrder,
      removeSingleSliderImage: staticPageEditorActions.removeSingleSliderImage,
      setSelectedImage: staticPageEditorActions.setSelectedImage,
      setSelectedGalleryImages:
        staticPageEditorActions.setSelectedGalleryImages,
      updateGalleryImageOrder: staticPageEditorActions.updateGalleryImageOrder,
      removeImageFromGallery: staticPageEditorActions.removeImageFromGallery,
      cloneGalleryImage: staticPageEditorActions.cloneGalleryImage,
      removeSingleGalleryImage:
        staticPageEditorActions.removeSingleGalleryImage,
      selectedImage: staticPageEditorActions.selectedImage,
      // ✅ Common props actions
      setProps: staticPageEditorActions.setProps,
      resetPropsState: staticPageEditorActions.resetPropsState,

      // ✅ Slice-specific actions
      setPublishedPage: staticPageEditorActions.setPublishedPage,
      setHasParentPage: staticPageEditorActions.setHasParentPage,
      setShowPageInMenu: staticPageEditorActions.setShowPageInMenu,
      setSelectedParentPage: staticPageEditorActions.setSelectedParentPage,
      setCurrentChildPages: staticPageEditorActions.setCurrentChildPages,
      resetPageEditorState: staticPageEditorActions.resetPageEditorState,
      selectSingleProduct: staticPageEditorActions.selectSingleProduct,
      clearSelectSingleProduct:
        staticPageEditorActions.clearSelectSingleProduct,
      selectSingleForm: staticPageEditorActions.selectSingleForm,
      clearSelectSingleForm: staticPageEditorActions.clearSelectSingleForm,
      selectSingleArticle: staticPageEditorActions.selectSingleArticle,
      clearSelectSingleArticle:
        staticPageEditorActions.clearSelectSingleArticle,
      displayedBlogs: staticPageEditorActions.displayedBlogs,
      clearDisplayedBlogs: staticPageEditorActions.clearDisplayedBlogs,
      displayedCategories: staticPageEditorActions.displayedCategories,
      clearDisplayedCategories:
        staticPageEditorActions.clearDisplayedCategories,
      loadStaticPageEditorInitialData:
        staticPageEditorActions.loadStaticPageEditorInitialData,
      resetCurrent: staticPageEditorActions.resetCurrent,
    },
    stateKey: "staticPageData",
  });

export default useStaticPageEditorManager;
