// redux/orderDataSlice.js
import { createSlice } from "@reduxjs/toolkit";

const initialState = {
  data: [],
  userFormData: {
    username: { value: "", isValid: false, isChecked: false },
    password: { value: "", isValid: false, isChecked: false },
    cegnev: { value: "", isValid: false, isChecked: false },
    adoszam: { value: "", isValid: false, isChecked: false },
    firstname: { value: "", isValid: false, isChecked: false },
    lastname: { value: "", isValid: false, isChecked: false },
    iranyitoszam: { value: "", isValid: false, isChecked: false },
    telepules: { value: "", isValid: false, isChecked: false },
    utca: { value: "", isValid: false, isChecked: false },
    telefon: { value: "", isValid: false, isChecked: false },
  },
  orderList: [],
  deliveryAddressList: [],
  selectedDeliveryAddress: null,
  selectedDeliveryDate: null,
  cartData: [],
  nettosum: 0,
  bruttosum: 0,
  favourites: [],
  adminNotes: [],
  company: false,
  private: false,
};

const orderDataSlice = createSlice({
  name: "orderData",
  initialState,
  reducers: {
    resetState: () => initialState,
    setUserData: (state, action) => {
      const { user } = action.payload;
      state.userFormData = user;
    },
    setAdminNotesList: (state, action) => {
      const { list } = action.payload;
      state.adminNotes = list;
    },
    setUserOrderList: (state, action) => {
      const { orderList } = action.payload;
      state.orderList = orderList;
    },
    setUserDeliveryAddressList: (state, action) => {
      const { deliveryAddressList } = action.payload;
      state.deliveryAddressList = deliveryAddressList;
    },
    addAddressToDeliveryList: (state, action) => {
      const { newAddress } = action.payload;
      state.deliveryAddressList = [...state.deliveryAddressList, newAddress];
    },
    setSelectedDeliveryAddress: (state, action) => {
      const { selectedAddress } = action.payload;
      state.selectedDeliveryAddress = selectedAddress;
    },
    setSelectedDeliveryDate: (state, action) => {
      const { selectedDate } = action.payload;
      state.selectedDeliveryDate = selectedDate;
    },
    updateCartData: (state, action) => {
      const { cartData } = action.payload;
      if (cartData?.length > 0) {
        state.cartData = [...state.cartData, ...cartData];
        let netto = 0,
          brutto = 0;
        state.cartData.map((c) => {
          netto += parseFloat(c.netto);
          brutto += parseFloat(c.brutto);
        });
        state.nettosum = netto;
        state.bruttosum = brutto;
      } else {
        state.cartData = [];
      }
    },
    addToCart: (state, action) => {
      const { id, qty, netto, brutto } = action.payload;

      const itemExists = state.cartData.find((item) => item.id === id);
      if (itemExists) {
        itemExists.qty = parseFloat(itemExists.qty) + parseFloat(qty);
        itemExists.netto = Math.round(
          parseFloat(itemExists.netto) + parseFloat(netto)
        ).toFixed(4);
        itemExists.brutto = Math.round(
          parseFloat(itemExists.brutto) + parseFloat(brutto)
        ).toFixed(4);
        state.nettosum = (
          parseFloat(state.nettosum) + parseFloat(netto)
        ).toFixed(4);
        state.bruttosum = (
          parseFloat(state.bruttosum) + parseFloat(brutto)
        ).toFixed(4);
      } else {
        state.cartData.push({ ...action.payload });
        state.nettosum = (
          parseFloat(state.nettosum) + parseFloat(netto)
        ).toFixed(4);
        state.bruttosum = (
          parseFloat(state.bruttosum) + parseFloat(brutto)
        ).toFixed(4);
      }
    },
    incrementQuantity: (state, action) => {
      const { id, qty, netto, brutto } = action.payload;
      const itemExists = state.cartData.find((item) => item.id === id);
      itemExists.qty = qty;
      itemExists.netto = parseFloat(netto);
      itemExists.brutto = parseFloat(brutto);
      // Recalculate nettoSum and bruttoSum
      const nettoSum = state.cartData.reduce(
        (sum, item) => parseFloat(sum) + parseFloat(item.netto),
        0
      );
      const bruttoSum = state.cartData.reduce(
        (sum, item) => parseFloat(sum) + parseFloat(item.brutto),
        0
      );

      // Update the state with the new sums
      state.nettosum = parseFloat(nettoSum);
      state.bruttosum = parseFloat(bruttoSum);
    },
    decrementQuantity: (state, action) => {
      const { id, qty, netto, brutto } = action.payload;
      const item = state.cartData.find((item) => item.id === id);
      if (item.qty === 1) {
        const index = state.findIndex((item) => item.id === id);
        state.cartData.splice(index, 1);
      } else {
        item.qty = qty;
        item.netto = parseFloat(netto);
        item.brutto = parseFloat(brutto);
        // Recalculate nettoSum and bruttoSum
        const nettoSum = state.cartData.reduce(
          (sum, item) => parseFloat(sum) + parseFloat(item.netto),
          0
        );
        const bruttoSum = state.cartData.reduce(
          (sum, item) => parseFloat(sum) + parseFloat(item.brutto),
          0
        );

        // Update the state with the new sums
        state.nettosum = parseFloat(nettoSum);
        state.bruttosum = parseFloat(bruttoSum);
      }
    },
    removeFromCart: (state, action) => {
      const { id, netto, brutto } = action.payload;
      const index = state.cartData.findIndex((item) => item.id === id);
      state.cartData.splice(index, 1);
      state.nettosum = (parseFloat(state.nettosum) - parseFloat(netto)).toFixed(
        4
      );
      state.bruttosum = (
        parseFloat(state.bruttosum) - parseFloat(brutto)
      ).toFixed(4);
    },
    setFavouritesList: (state, action) => {
      const { list } = action.payload;
      state.favourites = list;
    },
    addToFavourites: (state, action) => {
      const { product } = action.payload;
      const isFavourite = state.favourites.filter((x) => x._id === product._id);

      // Check if the filtered array is empty
      if (isFavourite.length === 0) {
        state.favourites.push(product);
      }
    },
    removeFromFavourites: (state, action) => {
      const { product } = action.payload;
      state.favourites = state.favourites.filter((x) => x._id !== product._id);
    },
  },
});

export const {
  resetState,
  setUserData,
  setUserOrderList,
  setUserDeliveryAddressList,
  addAddressToDeliveryList,
  setSelectedDeliveryAddress,
  setSelectedDeliveryDate,
  updateCartData,
  addToCart,
  incrementQuantity,
  decrementQuantity,
  removeFromCart,
  setAdminNotesList,
  setFavouritesList,
  addToFavourites,
  removeFromFavourites,
} = orderDataSlice.actions;

export default orderDataSlice.reducer;
