import { createSlice } from "@reduxjs/toolkit";
import {
  galleryInitialState,
  getGalleryReducers,
} from "../factory/gallerySliceFactory";

const customInitialState = {
  brandData: [],
  isPublished: true,
  description: "",
};

const initialState = {
  ...galleryInitialState,
  ...customInitialState,
};

export const productBrandSlice = createSlice({
  name: "productBrand",
  initialState,
  reducers: {
    setIsPublished: (state, action) => {
      // accept either boolean or { isPublished: { value: boolean } }
      if (typeof action.payload === "boolean") {
        state.isPublished = action.payload;
      } else {
        state.isPublished = !!action.payload?.isPublished?.value;
      }
    },
    setDescription: (state, action) => {
      const { description } = action.payload;
      state.description = description;
    },
    loadProductBrandInitialData: (state, action) => {
      const { brandData } = action.payload;
      state.isPublished = !!brandData?.is_published; // boolean
      state.featuredImage = brandData?.markFeaturedImage || [];
      state.description = brandData?.description;
    },
    ...getGalleryReducers(),
  },
});

export const {
  setFeaturedImage,
  resetFeaturedImageState,
  setIsPublished,
  setDescription,
  loadProductBrandInitialData,
} = productBrandSlice.actions;

export default productBrandSlice.reducer;
