import { createSlice } from "@reduxjs/toolkit";
import {
  galleryInitialState,
  getGalleryReducers,
} from "../factory/gallerySliceFactory";

const customInitialState = {
  categoryData: [],
  categories: [],
  showInMenu: false,
  isPublished: true,
};

const initialState = {
  ...galleryInitialState,
  ...customInitialState,
};

export const productCategoryDataSlice = createSlice({
  name: "productCategory",
  initialState,
  reducers: {
    setSelectedCategories: (state, action) => {
      state.categories = action.payload.categories;
    },
    removeCategoryFromList: (state, action) => {
      const { id } = action.payload;
      state.categoryData = state.categoryData.filter((c) => c._id !== id);
    },
    updateCategoryOrder: (state, action) => {
      const { start, end } = action.payload;
      state.categoryData = reorder(state.categoryData, start, end);
      state.categoryData.map((d, i) => {
        d.parentId = i;
      });
    },
    setShowInMenu: (state, action) => {
      state.showInMenu = action.payload.showInMenu;
    },
    setIsPublished: (state, action) => {
      state.isPublished = action.payload.isPublished;
    },
    resetCategoryState: () => initialState,
    loadProductCategoryInitialData: (state, action) => {
      const { categoryData } = action.payload;

      state.categories = categoryData.children;
      state.showInMenu = categoryData.showInMenu;
      state.isPublished = categoryData.isPublished;
      state.featuredImage = categoryData?.data?.featuredImage;
    },
    ...getGalleryReducers(),
  },
});

export const {
  setSelectedCategories,
  removeCategoryFromList,
  updateCategoryOrder,
  resetCategoryState,
  setFeaturedImage,
  resetFeaturedImageState,
  setIsPublished,
  setShowInMenu,
  loadProductCategoryInitialData,
} = productCategoryDataSlice.actions;

export default productCategoryDataSlice.reducer;
