import { createSlice } from "@reduxjs/toolkit";
import {
  containerInitialState,
  getContainerReducers,
} from "../factory/containerSliceFactory";
import {
  columnInitialState,
  getColumnReducers,
} from "../factory/columnSliceFactory";
import {
  elementInitialState,
  getElementReducers,
} from "../factory/elementSliceFactory";
import {
  galleryInitialState,
  getGalleryReducers,
} from "../factory/gallerySliceFactory";

const customInitialState = {
  size: null,
  color: null,
  tag: null,
  product_weight: 0,
  product_discount: 0,
  stock: 0,
  price_overridden: false,
  discount_overridden: false,
  product_parent_group_id: null,
  containerData: [],
  product_tags: [],
  product_item_number: "",
  product_ean: "",
  product_piece_webshop_price: 0,
  product_vat: 27,
  in_stock: false,
  is_active: true,
  is_latest: false,
  is_emphasized: false,
  featured_image: [],
  product_price_type: null,
};

const initialState = {
  ...containerInitialState,
  ...columnInitialState,
  ...elementInitialState,
  ...galleryInitialState,
  ...customInitialState,
};

const productItemSlice = createSlice({
  name: "productItem",
  initialState,
  reducers: {
    setTag: (state, action) => {
      state.tag = action.payload.tags;
    },
    setSize: (state, action) => {
      state.size = action.payload.size;
    },
    setColor: (state, action) => {
      state.color = action.payload.color;
    },
    setProductParentGroup: (state, action) => {
      state.product_parent_group_id = action.payload.product_parent_group_id;
    },
    setPriceOverride: (state, action) => {
      state.price_overridden = action.payload.price_overridden;
    },
    setDiscountOverride: (state, action) => {
      state.discount_overridden = action.payload.discount_overridden;
    },
    resetItemState: () => initialState,
    loadProductInitialData: (state, action) => {
      const { data, productProperties } = action.payload;
      if (!data) return;

      const tagIds = (data.product_tags || []).map((t) => t.id);
      const sizeIds = (data.product_size || []).map((s) => s.id);
      const colorIds = (data.product_color || []).map((c) => c.id);

      state.tag =
        productProperties.productTags?.filter((t) => tagIds.includes(t.id)) ||
        [];
      state.size =
        productProperties.productSize?.find((s) => sizeIds.includes(s.id)) ||
        [];
      state.color =
        productProperties.productColor?.find((c) => colorIds.includes(c.id)) ||
        [];

      state.in_stock = data.in_stock ?? false;
      state.is_active = data.is_active ?? true;
      state.is_latest = data.is_latest ?? false;
      state.is_emphasized = data.is_emphasized ?? false;

      state.containerData = data.product_content ?? [];
      state.price_overridden = data.price_overridden ?? false;
      state.discount_overridden = data.discount_overridden ?? false;

      state.product_item_number = data.product_item_number ?? "";
      state.product_ean = data.product_ean ?? "";
      state.product_piece_webshop_price = data.product_piece_webshop_price ?? 0;
      state.product_weight = data.product_weight ?? 0;
      state.product_discount = data.product_discount ?? 0;
      state.stock = data.stock ?? 0;
      state.product_vat = data.product_vat ?? 27;
      state.product_price_type = data.product_price_type;
      state.product_parent_group_id =
        data.product_parent_group_id ??
        productProperties.productGroupList?.find((g) => g.id === data.parentId)
          ?.id ??
        null;

      state.featured_image = Array.isArray(data.product_featured_image)
        ? data.product_featured_image
        : data.product_featured_image
        ? [data.product_featured_image]
        : [];
    },

    // Factories
    ...getContainerReducers(),
    ...getColumnReducers(),
    ...getElementReducers(),
    ...getGalleryReducers(),
  },
});

export const {
  setTag,
  setSize,
  setColor,
  setProductParentGroup,
  setPriceOverride,
  setDiscountOverride,
  resetItemState,
  loadProductInitialData,
  // Factory actions
  setFeaturedImage,
  resetFeaturedImageState,
  setSelectedGalleryImages,
  removeImageFromGallery,
  updateGalleryImage,
  updateGalleryImageOrder,
  resetGalleryState,
  selectedSliderImages,
  updateSliderImage,
  removeSingleSliderImage,
  updateSliderImageOrder,
  cloneSliderImage,
  resetSliderState,
  setSelectedImage,
  resetImageState,
  cloneGalleryImage,
  selectedGalleryImages,
  addContainer,
  setSelectedContainer,
  removeContainer,
  cleanCurrentlySelectedContent,
  setContainerList,
  updateContainerContent,
  selectedContainerOptions,
  setContainerTitle,
  resetContainerState,
  cloneContainer,
  updateContainerOrder,
  addColumn,
  setSelectedColumn,
  updateColumnOrder,
  updateColumnOptions,
  changeColumnSize,
  cloneColumn,
  removeColumn,
  selectedElement,
  cloneElement,
  updateColumnElementOrder,
  moveColumnElement,
  removeElement,
  setEditedElement,
  setSelectCurrentElement,
  addcurrentElementToColumn,
  resetElementState,
  publishedPage,
  activeLayout,
  staticPage,
  hasParent,
  showInMenu,
  resetCommonPropsState,
} = productItemSlice.actions;

export default productItemSlice.reducer;
