// store/slices/uploadLogSlice.js
import { createSlice } from "@reduxjs/toolkit";

const uploadLogSlice = createSlice({
  name: "uploadLog",
  initialState: {
    logs: [],
  },
  reducers: {
    addLog: (state, action) => {
      state.logs.push(action.payload);
    },
    clearLogs: (state) => {
      state.logs = [];
    },
  },
});

export const { addLog, clearLogs } = uploadLogSlice.actions;
export default uploadLogSlice.reducer;
