export const normalizeCheckboxes = (inputs, checkboxFields) => {
  const cleanedInputs = { ...inputs };

  checkboxFields.forEach((field) => {
    if (
      typeof cleanedInputs[field] === "object" &&
      cleanedInputs[field] !== null &&
      cleanedInputs[field].hasOwnProperty("isChecked")
    ) {
      cleanedInputs[field] = cleanedInputs[field].isChecked;
    } else if (typeof cleanedInputs[field] === "string") {
      // In case some checkbox returns string like "on"
      cleanedInputs[field] = cleanedInputs[field] === "on";
    } else {
      cleanedInputs[field] = Boolean(cleanedInputs[field]);
    }
  });

  return cleanedInputs;
};
